//
//  NSBezierPath+CRKit.h
//  CRKit
//
//  Based on Graham Cox's DrawKit
//

//////////////////////////////////////////////////////////////////////
// NSBezierPath
//////////////////////////////////////////////////////////////////////
@interface NSBezierPath(CRKit)

// Auxiliary
+ (NSBezierPath *)bezierPathWithCGPath:(CGPathRef)path;
- (CGPathRef)quartzPath;
- (void)setQuartzPathInContext:(CGContextRef)context;	// sets CGPathRef bsed on self and applies line styles and rules

// Stroked geometry as another NSBezierPath
- (NSBezierPath *)strokedPath;

// Quadric curve
- (void)curveToPoint:(NSPoint)endPoint controlPoint:(NSPoint)controlPoint;

// Text
- (void)appendBezierPathWithString:(NSString *)text inFont:(NSFont *)font;

@end